<?php
require_once "../database.php";
header('Content-Type: application/json');

if (!isset($_GET['email'])) {
    echo json_encode(["status" => "error", "message" => "Missing email"]);
    exit;
}

$email = $_GET['email'];

$stmt = $conn->prepare("
    SELECT 
        ar.result_image, 
        ar.result_pdf, 
        u.email 
    FROM admin_results ar
    JOIN users u ON ar.user_id = u.id
    WHERE u.email = :email
    ORDER BY ar.uploaded_at DESC 
    LIMIT 1
");

$stmt->execute([':email' => $email]);
$result = $stmt->fetch(PDO::FETCH_ASSOC);

if ($result) {
  

    echo json_encode([
        "status" => "success",
        "data" => $result
    ]);
} else {
    echo json_encode([
        "status" => "error",
        "message" => "No result found for this email"
    ]);
}
?>
