<?php
require_once "../database.php";
header('Content-Type: application/json');

$data = json_decode(file_get_contents("php://input"), true);
$title = $data['title'] ?? null;
$summary = $data['summary'] ?? null;
$content = $data['content'] ?? null;
$image_url = $data['image_url'] ?? null;
$status = $data['status'] ?? 'enabled';

if ($title && $summary && $content) {
    $stmt = $conn->prepare("INSERT INTO news (title, summary, content, image_url, status, published_at) VALUES (?, ?, ?, ?, ?, NOW())");
    $success = $stmt->execute([
        $title,
        $summary,
        $content,
        $image_url,
        $status
    ]);

    echo json_encode([
        "status" => $success ? "success" : "error",
        "message" => $success ? "News created successfully" : "Creation failed"
    ]);
} else {
    echo json_encode(["status" => "error", "message" => "Invalid or missing required data"]);
}
?>